<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        User::updateOrCreate(
            ['email' => 'admin@inaura.com'],
            [
                'name'       => 'Direktur',
                'password'   => Hash::make('password'),
                'role'       => 'admin',
                'department' => 'Direksi',
                'position'   => 'Direktur Utama',
            ]
        );

        User::updateOrCreate(
            ['email' => 'hrd@inaura.com'],
            [
                'name'       => 'HRGA',
                'password'   => Hash::make('password'),
                'role'       => 'hrd',
                'department' => 'HRGA',
                'position'   => 'HRGA Manager',
            ]
        );

        User::updateOrCreate(
            ['email' => 'user@inaura.com'],
            [
                'name'       => 'Karyawan Produksi',
                'password'   => Hash::make('password'),
                'role'       => 'user',
                'department' => 'Produksi',
                'position'   => 'Operator',
            ]
        );
    }

}

